///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Copyright  NetworkDLS 2002, All rights reserved
//
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF 
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A 
// PARTICULAR PURPOSE.
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef _CREATETRIGGERS_CPP
#define _CREATETRIGGERS_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <WindowsX.H>
#include <ShellAPI.H>
#include <Stdio.H>
#include <Stdlib.H>
#include <SQL.H>
#include <SQLExt.H>

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "../Resources/Resource.H"

#include "../../SharedClasses/CStatusDlg/CStatusDlg.H"
#include "../../SharedClasses/SQLClass/cSQL.H"
#include "../../SharedClasses/SQLClass/cRecordSet.H"
#include "../../SharedClasses/CGetPKs/CGetPKs.H"
#include "../../SharedSource/SQLTemplate.H"

#include "../CSockSrvr/CSockSrvr.H"

#include "../../SharedSource/Debug.H"
#include "../../SharedSource/NSWFL.H"
#include "../../SharedSource/Common.H"
#include "../../SharedSource/CRC32.H"

#include "Entry.H"
#include "Init.H"
#include "Routines.H"
#include "Console.H"
#include "Replication.H"

#include "../Dialogs/ReplicationDlg.H"
#include "../Dialogs/MainDlg.H"

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool DropReplicationTriggers(CSQL *lpCSQL, char *sDB, char *sTable)
{
	//WriteCon("DropReplicationTriggers\n");

	char sSQL[1024];
	char sTrigger[1024];

	int iSz = 0;

	bool bThrowErrors = lpCSQL->bThrowErrors;

	CRecordSet rsTriggers;

	lpCSQL->bThrowErrors = true;

	sprintf_s(sSQL, sizeof(sSQL), "SELECT [A].[Name]"
		" FROM [%s].[%s].[SysObjects] AS [A]"
		" INNER JOIN [%s].[%s].[SysObjects] AS [B] ON [A].[Parent_Obj] = [B].[ID]"
		" WHERE LEFT([A].[NAME], 8) = 'SQLExch_'"
		" AND [B].[Name] = '%s'",
		sDB, gsDefaultDBO, sDB, gsDefaultDBO, sTable);
	lpCSQL->Execute(sSQL, &rsTriggers);

	while(rsTriggers.Fetch())
	{
		if(rsTriggers.sColumnEx(1, sTrigger, sizeof(sTrigger), &iSz))
		{
			sprintf_s(sSQL, sizeof(sSQL), "DROP TRIGGER [%s]", sTrigger);
			lpCSQL->ExecuteNonQuery(sSQL);
		}
	}

	rsTriggers.Close();

	lpCSQL->bThrowErrors = bThrowErrors;

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//This function is complete!
bool DropReplicationTables(CSQL *lpCSQL, char *sTrgDB, char *sDB, char *sDBO, char *sTable)
{
	//WriteCon("DropReplicationTables\n");

	char sSQL[1024];
	bool bThrowErrors = lpCSQL->bThrowErrors;

	lpCSQL->bThrowErrors = false;

	sprintf_s(sSQL, sizeof(sSQL), "DROP TABLE [%s].[%s].[SQLExch_%s_%s_Trans]", sTrgDB, sDBO, sDB, sTable);
	lpCSQL->ExecuteNonQuery(sSQL);

	sprintf_s(sSQL, sizeof(sSQL), "DELETE FROM [%s].[%s].[SQLExch_Trans]"
		" WHERE [TransDB] = '%s' AND [TransTable] = '%s'", sTrgDB, sDBO, sDB, sTable);
	lpCSQL->ExecuteNonQuery(sSQL);

	lpCSQL->bThrowErrors = bThrowErrors;

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//This function is complete!
bool CreateReplicationTables(CSQL *lpCSQL, char *sTrgDB, char *sDB, char *sDBO, char *sTable)
{
	//WriteCon("CreateReplicationTables::");
	//WriteCon(sTable);
	//WriteCon("\n");

	char sSmlTmp[64];
	char sLargeSQL[10240];
	
	CGetPKs cGetPKs;

	if(cGetPKs.Get(lpCSQL, sDB, sDBO, sTable))
	{
		int iKey = 0;

		sprintf_s(sLargeSQL, sizeof(sLargeSQL),
			"CREATE TABLE [%s].[%s].[SQLExch_%s_%s_Trans] (\r\n",
			sTrgDB, sDBO, sDB, sTable);
		//strcat(sLargeSQL, "\t[SQLExch_ID] Numeric NOT NULL IDENTITY(1, 1),\r\n");

		while(iKey < cGetPKs.iPKs)
		{
			strcat_s(sLargeSQL, sizeof(sLargeSQL), "\t[");
			strcat_s(sLargeSQL, sizeof(sLargeSQL), cGetPKs.sPKs[iKey]);
			strcat_s(sLargeSQL, sizeof(sLargeSQL), "] ");

			strcat_s(sLargeSQL, sizeof(sLargeSQL), cGetPKs.sPKType[iKey]);

			if(cGetPKs.iPKStatus[iKey] == 1)
			{
				sprintf_s(sSmlTmp, sizeof(sSmlTmp), " (%d)", cGetPKs.iPKLen[iKey]);
				strcat_s(sLargeSQL, sizeof(sLargeSQL), sSmlTmp);
			}

			strcat_s(sLargeSQL, sizeof(sLargeSQL), " NULL,\r\n");

			iKey++;
		}

		//-------------------------------------------------------------
		//Need to add a SQLExch_Pending Bit column to each of the new tables.
		//	We use this column because of the following scenario:
		//		
		//		1) When a transfer begins we need to update SQLExch_Pending = 1.
		//		2) Next we need to select all of the rows where SQLExch_Pending = 1.
		//		3) While the Server and client excange data, and do imports and exports,
		//			the data may have changed, adding more rows to the table with a
		//			SQLExch_Pending flag equal to 0
		//		4) If the impot was a success then we delete from the table where SQLExch_Pending = 1
		//		5) The rows that were added durring the server/client conversation are
		//			preserved for the next transfer
		//-------------------------------------------------------------
		strcat_s(sLargeSQL, sizeof(sLargeSQL), "\t[SQLExch_Action] INT NOT NULL,\r\n");
		strcat_s(sLargeSQL, sizeof(sLargeSQL), "\t[SQLExch_Pending] Bit\r\n");
		strcat_s(sLargeSQL, sizeof(sLargeSQL), ") ON [PRIMARY]\r\n");

		lpCSQL->ExecuteNonQuery(sLargeSQL);

		cGetPKs.Free();
	}

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//This function is complete!
bool CreateReplicationTriggers(CSQL *lpCSQL, char *sTrgDB, char *sDB, char *sDBO, char *sTable)
{
	//WriteCon("CreateReplicationTriggers\n");

	char sLargeBaseSQL[10240];
	char sLargeSQL[10240];

	CGetPKs cGetPKs;

	if(cGetPKs.Get(lpCSQL, sDB, sDBO, sTable))
	{
		int iKey = 0;

		strcpy_s(sLargeSQL, sizeof(sLargeSQL), "");
		while(iKey < cGetPKs.iPKs)
		{
			strcat_s(sLargeSQL, sizeof(sLargeSQL), "[");
			strcat_s(sLargeSQL, sizeof(sLargeSQL), cGetPKs.sPKs[iKey]);
			strcat_s(sLargeSQL, sizeof(sLargeSQL), "] ");

			if(iKey != (cGetPKs.iPKs - 1))
			{
				strcat_s(sLargeSQL, sizeof(sLargeSQL), ",");
			}

			iKey++;
		}

		cGetPKs.Free();

		sprintf_s(sLargeBaseSQL, sizeof(sLargeBaseSQL),
			"CREATE TRIGGER [SQLExch_%s_%s_%%s_Trigger] ON [%s].[%s] WITH ENCRYPTION\r\n"
			"\tFOR %%s\r\n"
			"\tAS\r\n"
			"\t\tINSERT INTO [%s].[%s].[SQLExch_%s_%s_Trans] (%s, [SQLExch_Action])\r\n\t\t\tSELECT %s, '%%s' FROM [%%s]\r\n"
			"GO\r\nINSERT INTO [%s].[%s].[SQLExch_Trans]([TransTable], [TransDB]) VALUES('%s', '%s')", 
			sDB, sTable, sDBO, sTable,
			sTrgDB, sDBO, sDB, sTable, sLargeSQL, sLargeSQL,
			sTrgDB, sDBO, sTable, sDB);

		sprintf_s(sLargeSQL, sizeof(sLargeSQL), sLargeBaseSQL,
			"Update", "INSERT, UPDATE", "1", "Inserted");
		lpCSQL->ExecuteNonQuery(sLargeSQL);

		sprintf_s(sLargeSQL, sizeof(sLargeSQL), sLargeBaseSQL,
			"Delete", "DELETE", "2", "Deleted");
		lpCSQL->ExecuteNonQuery(sLargeSQL);
	}

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//This function is complete!
bool CreateReplicationEx(CSQL *lpCSQL, char *sTrgDB, char *sDB, char *sDBO, char *sTable, HWND hGrid, int iCol, int iItem)
{
	//WriteCon("CreateReplication\n");

	if(GenerateReplicationScripts(NULL, sTrgDB, sDBO, false))
	{
		lpCSQL->bThrowErrors = false;
		SetStatus(hGrid, iCol, iItem, "Dropping Triggers.");
		DropReplicationTriggers(lpCSQL, sDB, sTable);

		SetStatus(hGrid, iCol, iItem, "Dropping Tables.");
		DropReplicationTables(lpCSQL, sTrgDB, sDB, sDBO, sTable);
		lpCSQL->bThrowErrors = true;

		SetStatus(hGrid, iCol, iItem, "Creating Tables.");
		if(CreateReplicationTables(lpCSQL, sTrgDB, sDB, sDBO, sTable))
		{
			SetStatus(hGrid, iCol, iItem, "Creating Triggers.");
			return CreateReplicationTriggers(lpCSQL, sTrgDB, sDB, sDBO, sTable);
		}
	}

	return false;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//This function is complete!
bool CreateReplication(CSQL *lpCSQL, char *sTrgDB, char *sDB, char *sDBO, char *sTable)
{
	return CreateReplicationEx(lpCSQL, sTrgDB, sDB, sDBO, sTable, NULL, 0, 0);
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//This function is incomplete!
bool CreateReplicationDB(CSQL *lpSQL, CStatusDlg *lpDlg, char *sTrgDB, char *sDBO)
{
	char sSQL[10240];
	CRecordSet rsDBExist;

	SQLTEMPLATE MySQLTemp;

	memset(&MySQLTemp, 0, sizeof(MySQLTemp));

	sprintf_s(sSQL, sizeof(sSQL),
		"SELECT Count(*) FROM [SysDatabases] WHERE [Name] = 'SQLExch_Replication'");
	lpSQL->Execute(sSQL, &rsDBExist);

	if(rsDBExist.Fetch())
	{
		if(rsDBExist.lColumn(1) > 0)
		{
			return true;
		}
	}
	else{
		WriteSysLogEx("Failed to fetch SysDatabases count.", EVENT_ERROR);
		return false;
	}

	rsDBExist.Close();

	MySQLTemp.iMask = SQLTMP_DBDIR | SQLTMP_DB;
	MySQLTemp.sDBDir = gsSQLDataFiles;
	MySQLTemp.sDB = sTrgDB;

	if(BuildSQLFromTemplate(gsPath, "SQLExch_Create_DB.sql", sSQL, &MySQLTemp))
	{
		if(lpSQL->ExecuteNonQuery(sSQL))
		{
			return true;
		}
		else{
			WriteSysLogEx("Failed to create SQLExch_Replication database.", EVENT_ERROR);
			return false;
		}
	}
	else{
		WriteSysLogEx("Failed to build template for SQLExch_Replication database creation.", EVENT_ERROR);
		return false;
	}

	WriteSysLogEx("unknown error while creating SQLExch_Replication database.", EVENT_ERROR);
	
	return false;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool GenerateReplicationScripts(CStatusDlg *lpDlg, char *sTrgDB, char *sDBO, bool bCreate)
{
	//WriteCon("GenerateReplicationScripts\n");

	char sSQL[10240];
	int iTempSz = 0;
	int iLen = 0;
	long lSeq = 1000;
	long lLoop = 0;

	FILE *hSource = NULL;

	char sOnSuccess[1024];
	char sOnFailure[1024];

	char sWhereClause[10240];
	char sLargeSQL[10240];
	char sPKList[5120];
	char sTable[1024];
	char sTemp[1024];
	char sDB[255];
	char sRepTable[1024];

	CGetPKs cGetPKs;

	CSQL cSQL;
	CRecordSet rsTables;
	CRecordSet rsDatabases;

	SQLTEMPLATE MySQLTemp;

	memset(&MySQLTemp, 0, sizeof(MySQLTemp));

	if(lpDlg)
	{
		lpDlg->SetText("Generating scripts required for replication.");
		lpDlg->SetProgressPos(0);
	}

	if(!cSQL.Connect(gsSQLDriver, gsSQLServer, gsSQLUserID, gsSQLPassword, "Master", gsDBMode))
	{
		MessageBox(NULL,
			"Failed to connect to the SQL server.",
			gsTitleCaption, MB_TASKMODAL|MB_ICONERROR);

		return false;
	}

	cSQL.bThrowErrors = true;
	if(!CreateReplicationDB(&cSQL, lpDlg, sTrgDB, sDBO))
	{
		MessageBox(NULL,
			"Failed to create the replicaton database, all existing replications should be removed.",
			gsTitleCaption, MB_TASKMODAL|MB_ICONERROR);

		cSQL.Disconnect();
		return false;
	}

	cSQL.bThrowErrors = false;
	sprintf_s(sSQL, sizeof(sSQL),
		"CREATE TABLE [%s].[%s].[SQLExch_Trans] (\r\n"
		"[TransDB] [varchar] (255) NULL,\r\n"
		"[TransTable] [varchar] (255) NULL,\r\n"
		"[SQLExch_Pending] [Bit] NULL\r\n"
		") ON [PRIMARY]", sTrgDB, sDBO);
	cSQL.ExecuteNonQuery(sSQL);
	cSQL.bThrowErrors = true;

	MySQLTemp.iMask = SQLTMP_DBDIR | SQLTMP_DB;
	MySQLTemp.sDBDir = gsSQLDataFiles;
	MySQLTemp.sDB = sTrgDB;

	if(BuildSQLFromTemplate(gsPath, "SQLExch_Statements.sql", sSQL, &MySQLTemp))
	{
		//Drop the SQLExch_Statements table.
		sprintf_s(sLargeSQL, sizeof(sLargeSQL),
			"DROP TABLE [%s].[%s].[SQLExch_Statements]", sTrgDB, sDBO);
		cSQL.bThrowErrors = false;
		cSQL.ExecuteNonQuery(sLargeSQL); 
		cSQL.bThrowErrors = true;

		//Recreate the SQLExch_Statements table.
		cSQL.ExecuteNonQuery(sSQL);
	}
	else{
		cSQL.Disconnect();
		return false;
	}

	if(!bCreate)
	{
		cSQL.Disconnect();
		return true;
	}

	strcpy_s(sSQL, sizeof(sSQL),
		"SELECT [Name] FROM [SysDatabases]"
		" WHERE [Name] NOT LIKE 'SQLExch_%'"
		" AND [Name] NOT IN ('Master', 'Model', 'MSDB', 'TempDB')"
		" ORDER BY [Name]");
	cSQL.Execute(sSQL, &rsDatabases);	

	while(rsDatabases.Fetch())
	{
		rsDatabases.sColumnEx(1, sDB, sizeof(sDB), &iTempSz);

		//----------------------------------------------------------------------------------------------------

		//Create a record set containing all of the table names that contain SQLExch_ triggers
		sprintf_s(sSQL, sizeof(sSQL),
			"SELECT [Name]"
			" FROM [%s].[%s].[SysObjects]"
			" WHERE [xType] = 'U' AND (LEFT([NAME], 8) <> 'SQLExch_'"
			" AND [ID] IN (SELECT [Parent_Obj] FROM [%s].[%s].SysObjects AS [A]"
			" WHERE [A].[xType] = 'TR' AND LEFT([A].[NAME], 8) = 'SQLExch_'))"
			" ORDER BY [Name]", sDB, sDBO, sDB, sDBO);
		cSQL.Execute(sSQL, &rsTables);

		if(rsTables.RowCount > 0)
		{
			if(lpDlg)
			{
				sprintf_s(sTemp, sizeof(sTemp), "Creating replications. [%s]", sDB);
				lpDlg->SetText(sTemp);
				lpDlg->SetProgressRange(0, rsTables.RowCount);
				lpDlg->SetProgressPos(0);
				lLoop = 0;
				Sleep(1000);
			}

			//Loop through all of the tables that have triggers.
			while(rsTables.Fetch())
			{
				//Get the table name, save it in sTable[]
				rsTables.sColumnEx(1, sTable, sizeof(sTable), &iTempSz);

				sprintf_s(sRepTable, sizeof(sRepTable), "SQLExch_%s_%s_Trans", sDB, sTable);

				//Get a list of primary keys for the table.
				if(cGetPKs.Get(&cSQL, sDB, sDBO, sTable))
				{
					int iTrgTable = 0;

					//----------------------------------------------------------------------------------------
					//Insert the first statement into the "SQLExch_Statements" table.
					//----------------------------------------------------------------------------------------

					sprintf_s(sTemp, sizeof(sTemp),
						"UPDATE [%s].[%s].[SQLExch_%s_%s_Trans] SET SQLExch_Pending = 1",
						sTrgDB, sDBO, sDB, sTable);

					sprintf_s(sSQL, sizeof(sSQL),
						"INSERT INTO [%s].[%s].SQLExch_Statements ([Statement], [OnSuccess],"
						" [Sequence], [Active], [TransTable], [TransDB], [RepTable], [PrimarySelect], [Comments])"
						" VALUES('%s', NULL, '%d', '1', '%s', '%s', '%s', 0, 'Auto Generated.')",
						sTrgDB, sDBO, sTemp, lSeq, sTable, sDB, sRepTable);
					cSQL.ExecuteNonQuery(sSQL);
					lSeq = (lSeq + 10);

					//----------------------------------------------------------------------------------------

					int iKey = 0;

					strcpy_s(sWhereClause, sizeof(sWhereClause), "WHERE");

					strcpy_s(sPKList, sizeof(sPKList), "");

					//Loop through all of the primary keys
					while(iKey < cGetPKs.iPKs)
					{
						strcat_s(sWhereClause, sizeof(sWhereClause), " [");
						strcat_s(sWhereClause, sizeof(sWhereClause), sTable);
						strcat_s(sWhereClause, sizeof(sWhereClause), "].");

						strcat_s(sWhereClause, sizeof(sWhereClause), "[");
						strcat_s(sWhereClause, sizeof(sWhereClause), cGetPKs.sPKs[iKey]);
						strcat_s(sWhereClause, sizeof(sWhereClause), "] = ");

						strcat_s(sWhereClause, sizeof(sWhereClause), "[SQLExch_Trans].");

						strcat_s(sWhereClause, sizeof(sWhereClause), "[");
						strcat_s(sWhereClause, sizeof(sWhereClause), cGetPKs.sPKs[iKey]);
						strcat_s(sWhereClause, sizeof(sWhereClause), "] AND");

						strcat_s(sPKList, sizeof(sPKList), "[");
						strcat_s(sPKList, sizeof(sPKList), cGetPKs.sPKs[iKey]);
						strcat_s(sPKList, sizeof(sPKList), "]");
						if(iKey != cGetPKs.iPKs - 1)
						{
							strcat_s(sPKList, sizeof(sPKList), ", ");
						}

						iKey++;
					}

					//----------------------------------------------------------------------------------------
					//Write the 'Updated / Inserted Records' statement.
					//----------------------------------------------------------------------------------------

					//Default OnFailure SQL.
					sprintf_s(sOnFailure, sizeof(sOnFailure),
						"UPDATE [%s].[%s].[SQLExch_Trans]"
						" SET [SQLExch_Pending] = 0"
						" WHERE [SQLExch_Pending] = 1 AND [TransTable] = ''%s''",
						sTrgDB, sDBO, sTable);

					//Default sOnSuccess SQL.
					sprintf_s(sOnSuccess, sizeof(sOnSuccess),
						"DELETE FROM [%s].[%s].[SQLExch_%s_%s_Trans]"
						" WHERE [SQLExch_Pending] = 1 AND [SQLExch_Action] = 1",
						sTrgDB, sDBO, sDB, sTable);

					//We need to be able to select DISTINCT, but the ntext, text, image types dont like it.
					//sprintf_s(sLargeSQL, "SELECT DISTINCT %s.*"
					sprintf_s(sLargeSQL, sizeof(sLargeSQL),
						"SELECT [%s].*"
						" FROM [%s].[%s].[%s] AS [%s], [%s].[%s].[SQLExch_Temp] AS [SQLExch_Trans]"
						" %s [SQLExch_Trans].[SQLExch_Pending] = 1 AND"
						" [SQLExch_Trans].[SQLExch_Action] = 1",
						sTable, sDB, sDBO, sTable, sTable, sTrgDB, sDBO, sWhereClause);

					sprintf_s(sSQL, sizeof(sSQL),
						"INSERT INTO [%s].[%s].SQLExch_Statements ([Statement], [OnSuccess],"
						" [OnFailure], [ImportTable], [Sequence], [Active], [TransTable], [TransDB],"
						" [RepTable], [PrimarySelect], [Comments])"
						" VALUES('%s', '%s', '%s', '%s', '%d', '1', '%s', '%s', '%s', 0, 'Auto Generated.')",
						sTrgDB, sDBO, sLargeSQL, sOnSuccess, sOnFailure, sTable, lSeq, sTable, sDB, sRepTable);
					cSQL.ExecuteNonQuery(sSQL);
					lSeq = (lSeq + 10);

					//----------------------------------------------------------------------------------------
					//Write the 'Deleted Records' statement.
					//----------------------------------------------------------------------------------------

					//No default OnFailure SQL.
					strcpy_s(sOnFailure, sizeof(sOnFailure), "");

					//Default sOnSuccess SQL.
					sprintf_s(sOnSuccess, sizeof(sOnSuccess),
						"DELETE FROM [%s].[%s].[SQLExch_%s_%s_Trans]"
						" WHERE [SQLExch_Pending] = 1 AND [SQLExch_Action] = 2 AND [SQLExch_Action] = 2",
						sTrgDB, sDBO, sDB, sTable);

					sprintf_s(sLargeSQL, sizeof(sLargeSQL),
						"SELECT DISTINCT %s"
						" FROM [%s].[%s].[SQLExch_%s_%s_Trans]"
						" WHERE [SQLExch_Pending] = 1 AND [SQLExch_Action] = 2",
						sPKList, sTrgDB, sDBO, sDB, sTable);

					sprintf_s(sSQL, sizeof(sSQL),
						"INSERT INTO [%s].[%s].SQLExch_Statements ([Statement], [OnSuccess],"
						" [ImportTable], [Sequence], [Active], [TransTable], [TransDB], [RepTable],"
						" [PrimarySelect], [Comments])"
						" VALUES('%s', '%s', '%s_SQLExch_Delete', '%d', '1',"
						" '%s', '%s', '%s', 1, 'Auto Generated.')",
						sTrgDB, sDBO, sLargeSQL, sOnSuccess, sTable, lSeq, sTable, sDB, sRepTable);
					cSQL.ExecuteNonQuery(sSQL);
					lSeq = (lSeq + 10);

					cGetPKs.Free();
				}

				if(lpDlg)
				{
					lLoop++;
					lpDlg->SetProgressPos(lLoop);
				}
			}
		}

		rsTables.Close();
	}

	rsDatabases.Close();

	cSQL.Disconnect();

	return true;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
